//	@(#)SnmpConstants.java	1.1	06/03/98
//  SNMP Version 1 Package

package	jsnmp;

public class SnmpConstants {

static int ReqID = 0; // The request ID used to track requests

static public int SNMP_PORT	=   161;
static public int SNMP_TRAP_PORT	=   162;
static int SNMP_MAX_LEN	=   484;
static int SNMP_VERSION_1	=   0;

	/** Constant for SNMP get PDU type. */
	public static final byte GET_REQ_MSG =
				(byte)(ASNTypes.ASN_CONTEXT | ASNTypes.ASN_CONSTRUCTOR | 0x0);
	/** Constant for SNMP get next PDU type. */
	public static final byte GETNEXT_REQ_MSG =
				(byte)(ASNTypes.ASN_CONTEXT | ASNTypes.ASN_CONSTRUCTOR | 0x1);
	/** Constant for SNMP response PDU type */
	public static final byte GET_RSP_MSG =
				(byte)(ASNTypes.ASN_CONTEXT | ASNTypes.ASN_CONSTRUCTOR | 0x2);
	/** Constant for SNMP set request PDU type. */
	public static final byte SET_REQ_MSG =
				(byte)(ASNTypes.ASN_CONTEXT | ASNTypes.ASN_CONSTRUCTOR | 0x3);
	/** Constant for SNMP trap PDU type. */
	public static final byte TRP_REQ_MSG =
				(byte)(ASNTypes.ASN_CONTEXT | ASNTypes.ASN_CONSTRUCTOR | 0x4);

	static final byte SNMP_ERR_NOERROR = 0x0;
	static final byte SNMP_ERR_TOOBIG = 0x1;
	static final byte SNMP_ERR_NOSUCHNAME = 0x2;
	static final byte SNMP_ERR_BADVALUE = 0x3;
	static final byte SNMP_ERR_READONLY = 0x4;
	static final byte SNMP_ERR_GENERR = 0x5;

	static final byte SNMP_TRAP_COLDSTART		=  0x0;
	static final byte SNMP_TRAP_WARMSTART		=  0x1;
	static final byte SNMP_TRAP_LINKDOWN		=  0x2;
	static final byte SNMP_TRAP_LINKUP			=  0x3;
	static final byte SNMP_TRAP_AUTHFAIL		=  0x4;
	static final byte SNMP_TRAP_EGPNEIGHBORLOSS	=  0x5;
	static final byte SNMP_TRAP_ENTERPRISESPECIFIC	= 0x6;

	public final static byte INTEGER = ASNTypes.ASN_INTEGER;
	public final static byte STRING	= ASNTypes.ASN_OCTET_STR;
	public final static byte OBJID = ASNTypes.ASN_OBJECT_ID;
	public final static byte NULLOBJ = ASNTypes.ASN_NULL;

	/** defined types (from the SMI, RFC 1065) */
	public final static byte IPADDRESS = (byte)(ASNTypes.ASN_APPLICATION | 0x0);
	public final static byte COUNTER = (byte)(ASNTypes.ASN_APPLICATION | 0x1);
	public final static byte GAUGE = (byte)(ASNTypes.ASN_APPLICATION | 0x2);
	public final static byte TIMETICKS = (byte)(ASNTypes.ASN_APPLICATION | 0x3);
	public final static byte OPAQUE = (byte)(ASNTypes.ASN_APPLICATION | 0x4);

	static int  SID_MAX_LEN	= 64;
	static int  MAX_NAME_LEN =64;  /* number of subid's in a objid */

}
