//  @(#)SnmpException.java	1.2	06/04/98
//  SNMP Version 1 Package

package	jsnmp;

import java.util.*;

public class SnmpException extends Exception {

	private SnmpErrors	error;

    public SnmpException() {
        super();
    }

    public SnmpException(String s) {
        super(s);
    }

	public SnmpException(int type, int code) {
		error = new SnmpErrors(type, code);
	}

	public SnmpErrors getError() {
		return error;
	}

	public static String exceptionString(int error) {

		switch (error) {
		case SnmpConstants.SNMP_ERR_NOERROR: 
			return("No Error.");
		case SnmpConstants.SNMP_ERR_TOOBIG: 
			return("Response message would have been too large.");
		case SnmpConstants.SNMP_ERR_NOSUCHNAME: 
			return("There is no such variable name in this MIB.");
		case SnmpConstants.SNMP_ERR_BADVALUE: 
			return("The value given has the wrong type or length.");
		case SnmpConstants.SNMP_ERR_READONLY: 
			return("This variable is read only.");
		case SnmpConstants.SNMP_ERR_GENERR: 
			return("A general failure occured.");
		default:
			return("I don't know what occured.");
		}
	}

}
