//  @(#)SnmpInt.java	1.3	06/17/98
//  SNMP Version 1 Package

package	jsnmp;

import	java.math.*;
//import	java.util.*;
import	java.io.*;

/**
 *  Handles each occurance of an ASN.1 INTEGER mib variable, by extending
 *  the SnmpVar abstract class.
 */
public class SnmpInt extends SnmpVar {

	private BigInteger value;

	/**
	 *  Creates an SnmpInt variable with a zero initial value.
	 */
	public SnmpInt() {
		value = new BigInteger("0");
		type = SnmpConstants.INTEGER;
	}

	/**
	 *  Creates an SnmpInt variable with an initial value of i.
	 */
	public SnmpInt(int i) { 
		value = new BigInteger(Integer.toString(i));
		type = SnmpConstants.INTEGER;
	}

	/**
	 *  Returns the value of the ASN.1 INTEGER variable.
	 */
	public Object getValue() {
		return value;
	}

	/**
	 *  Returns the value of the INTEGER variable as a printable string.
	 */
	public String toString() {
		return value.toString();
	}

	/**
	 *  Encodes an integer (arbitrary precision) into an ASN.1 INTEGER.
	 */
	public byte[] encode() {  
		byte[]	integer = value.toByteArray();
		byte hdr[] = ASNTypes.putTagLength(type, integer.length);
		byte data[] = new byte[hdr.length + integer.length];
		System.arraycopy(hdr, 0, data, 0, hdr.length);
		System.arraycopy(integer, 0, data, hdr.length, integer.length);

		return data;
	}


	/**
	 *  Decodes an ASN.1 INTEGER to a BigInteger.
	 */
	public void decode(ByteArrayInputStream pdu, int length)
			throws SnmpException {
		byte[]	integer = new byte[length];

		for (int i = 0; i < length; i++) {
			integer[i] = (byte)pdu.read();
		}
		value = new BigInteger(integer);
	}

}
