//  @(#)SnmpIpAddress.java	1.2	06/15/98
//  SNMP Version 1 Package

package	jsnmp;

import java.util.*;
import java.io.*;
import java.net.*;

public class SnmpIpAddress extends SnmpVar {

	private InetAddress	ipAddress;

	public SnmpIpAddress(String s) { 
		type = SnmpConstants.IPADDRESS;
		try { 
			ipAddress = InetAddress.getByName(s); 
		} 
		catch (UnknownHostException e) {
		}
	}

	public SnmpIpAddress(byte[] ip) {
		type = SnmpConstants.IPADDRESS;
		try { 
			ipAddress = InetAddress.getByName(new String(ip)); 
		} 
		catch (UnknownHostException e) {
		}
	}

	public Object getValue() {
		return ipAddress;
	}

	public String toString() {   
		return ipAddress.getHostAddress();
	}

	public byte[] encode() {
		byte hdr[] = ASNTypes.putTagLength(SnmpConstants.IPADDRESS, 4);

		if (hdr == null) {
			return null;
		}
		byte data[] = new byte[hdr.length + 4];
		System.arraycopy(hdr, 0, data, 0, hdr.length);
		System.arraycopy(ipAddress.getAddress(), 0, data, hdr.length + 1, 4);

		return data;

	}

	public void decode(ByteArrayInputStream b, int length) 
			throws SnmpException {
		byte data[] = new byte[length];

		b.read(data, 0, length);

		int	first = (data[0] < 0)? data[0] + 256 : data[0];
		int	second = (data[1] < 0)? data[1] + 256 : data[1];
		int	third = (data[2] < 0)? data[2] + 256 : data[2];
		int	fourth = (data[3] < 0)? data[3] + 256 : data[3];
		String addr = first + "." + second + "." + third + "." + fourth;

		try {
			ipAddress = InetAddress.getByName(addr);
		}
		catch (UnknownHostException e) {
			throw new SnmpException(SnmpErrors.INVALID_HOST, 0);
		}
	}

}
