//  @(#)SnmpNull.java	1.1	06/03/98
//  SNMP Version 1 Package

package	jsnmp;

import java.util.*;
import java.io.*;

/*
 *  Class of SNMP Null Variable - Sub-class of SnmpVar
 */

public class SnmpNull extends SnmpVar {

	private int	value = 0;

	public SnmpNull() {
		type = ASNTypes.ASN_NULL;
	}

/** Function to return value of SNMP variable as an appropriate Object type,
 *    in this case returns null.  
 */
	public Object getValue() {
		return null;
	}

    /** To convert the object to a printable string */
	public String toString() {
		return new String("NULL");
	}

	/** ASN encoder */
	public byte[] encode() {
		return ASNTypes.putTagLength(SnmpConstants.NULLOBJ,0);
	}

	/** ASN decoder */
	public void decode(ByteArrayInputStream b, int length) 
			throws SnmpException {
		return;
	}

}
