//  %W%	%G%
//  SNMP Version 1 Package

package	jsnmp;

import java.util.*;
import java.io.*;

/*
 *  Class of SNMP String Variable - Sub-class of SnmpVar
 */

public class SnmpOctetString extends SnmpVar {

	protected byte[] value;

	public SnmpOctetString(byte[] s) {
		value = s;
		type = SnmpConstants.STRING;
	}

	public SnmpOctetString(String s) {
		value = s.getBytes();
		type = SnmpConstants.STRING;
	}

	public Object getValue() { 
		return value;
	}

    /** To convert the object to a printable string */
	public String toString() {
		return new String(value);
	}

	/** ASN encoder */
	public byte[] encode() {
		int		siz = value.length;
		byte	hdr[] = ASNTypes.putTagLength(SnmpConstants.STRING, siz);

		if (hdr == null) {
			return null;
		}

		byte data[] = new byte[hdr.length + siz];
		System.arraycopy(hdr, 0, data, 0, hdr.length);
		System.arraycopy(value, 0, data, hdr.length, siz);

		return data;
	}

	/** ASN decoder */
	public void decode(ByteArrayInputStream b, int length) 
			throws SnmpException {
	    //System.out.println("Length:"+length);
		value = new byte[length];
		if (length > 0) {
			b.read(value, 0, length);
		}
	}

}
