//  @(#)SnmpOpaque.java	1.3	06/17/98
//  SNMP Version 1 Package

package	jsnmp;

/*
 *  Class of SNMP Opaque Variable - Sub-class of SnmpString
 */
public class SnmpOpaque extends SnmpOctetString {

	/** Constructor takes a String object as its argument */
	public SnmpOpaque(String s) { 
		super(s); 
		type = SnmpConstants.OPAQUE;
	}

/** ASN encoder */
	public byte[] encode() {
		int		siz = value.length;
		byte	hdr[] = ASNTypes.putTagLength(SnmpConstants.OPAQUE, siz);

		if (hdr == null) {
			return null;
		}
		byte data[] = new byte[hdr.length + siz];
		System.arraycopy(hdr, 0, data, 0, hdr.length);
		System.arraycopy(value, 0, data, hdr.length, siz);
		//value.getBytes(0,siz,data,hdr.length);  // Is this siz-1?

		return data;
	}

}
