//  @(#)SnmpTimeticks.java	1.3	06/23/98
//  SNMP Version 1 Package

package	jsnmp;

import	java.math.*;

/*
 *  Class of SNMP Timeticks Variable - Sub-class of SnmpVar
 */

public class SnmpTimeticks extends SnmpUnsignedInt {

/** The constructor takes a long type as it's argument */

	public SnmpTimeticks(int time) { 
		super(time); 
		type = SnmpConstants.TIMETICKS;
	}

/** To convert the object to a printable string with # days, # hours, etc. : */

	public String toString() {
		StringBuffer s = new StringBuffer();
		long timeticks = ((BigInteger)getValue()).longValue();
		int seconds, minutes, hours, days;

		timeticks /= 100;
		days = (int) (timeticks / (60 * 60 * 24));
		timeticks %= (60 * 60 * 24);

		hours = (int) (timeticks / (60 * 60));
		timeticks %= (60 * 60);

		minutes = (int) (timeticks / 60);
		seconds = (int) (timeticks % 60);

		if (days == 1) {
			s.append("1 day, ");
		}
		else if (days != 0) {
			s.append(days + " days, ");
		}

		s.append(hours + " hours, ");
		s.append(minutes + " minutes, ");
		s.append(seconds + " seconds. ");

		return s.toString();
	}

}
