//  @(#)SnmpUnsignedInt.java	1.1	06/23/98
//  SNMP Version 1 Package

package	jsnmp;

import	java.math.*;
import	java.io.*;

/**
 *  Handles each occurance of an ASN.1 INTEGER mib variable, by extending
 *  the SnmpVar abstract class.
 */
public class SnmpUnsignedInt extends SnmpVar {

	private BigInteger value;

	/**
	 *  Creates an SnmpInt variable with a zero initial value.
	 */
	public SnmpUnsignedInt() {
		value = new BigInteger("0");
		type = SnmpConstants.INTEGER;
	}

	/**
	 *  Creates an SnmpInt variable with an initial value of i.
	 */
	public SnmpUnsignedInt(int i) { 
		value = new BigInteger(Integer.toString(i));
		type = SnmpConstants.INTEGER;
	}

	/**
	 *  Returns the value of the ASN.1 INTEGER variable.
	 */
	public Object getValue() {
		return value;
	}

	/**
	 *  Returns the value of the INTEGER variable as a printable string.
	 */
	public String toString() {
		return value.toString();
	}

	/**
	 *  Encodes an integer (arbitrary precision) into an ASN.1 INTEGER.
	 */
	public byte[] encode() {  
		byte[]	integer = value.toByteArray();
		byte hdr[] = ASNTypes.putTagLength(type, integer.length);
		byte data[] = new byte[hdr.length + integer.length];
		System.arraycopy(hdr, 0, data, 0, hdr.length);
		System.arraycopy(integer, 0, data, hdr.length, integer.length);

		return data;
	}


	/**
	 *  Decodes an ASN.1 INTEGER to a BigInteger.
	 */
	public void decode(ByteArrayInputStream pdu, int length)
			throws SnmpException {
		int	i = 0;

		if (length == 0) {
			return;
		}

		byte	first = (byte)pdu.read();
		byte[]	integer = new byte[(first < 0)? length + 1 : length];

		if (first < 0) {
			integer[i++] = 0;
			integer[i++] = first;
		}
		else {
			integer[i++] = first;
		}
		for (int j = 1; j < length; j++) {
			integer[i++] = (byte)pdu.read();
		}
		value = new BigInteger(integer);
	}

}
