//  @(#)SnmpVar.java	1.2	06/16/98
//  SNMP Version 1 Package

package	jsnmp;

import java.util.*;
import java.io.*;

/**
 *  This base class acts as the template for all other SNMP variables.
 */

public abstract class SnmpVar {

	protected byte type;  

	/**
	 *  Class method to extract the variable type value.
	 */
	public byte getType() {
		return type;
	}

	/**
	 *  Method used by all SNMP variable definitions to fetch the variable
	 *  value.
	 */
	public abstract Object getValue();  

	/**
	 *  Method used to produce a printable string for variable value.
	 */
	public abstract String toString();     

	/**
	 *  Method used to create (encode) the byte stream for the current
	 *  SNMP variable.
	 */
	public abstract byte[] encode();  

	/**
	 *  Method used to extract (decode) the received byte stream for
	 *  the current SNMP variable.
	 */
	public abstract void decode(ByteArrayInputStream b, int length)
		throws SnmpException;  

}
