//  @(#)SnmpVarBind.java	1.2	06/15/98
//  SNMP Version 1 Package

package	jsnmp;

import java.util.*;
import java.io.*;

public class SnmpVarBind {

	private SnmpOID oid = null;
	private SnmpVar variable = null;

	public String toString() {
		return ((oid == null ) || (variable == null ))? null :
										new String(oid + ": " + variable);
	}

	public String getName() {
		return oid.toString();
	}

	public byte getType() {
		return variable.type;
	}

	public Object getValue() {
		return variable.getValue();
	}

	public void putName(SnmpOID oid) {
		this.oid = oid;
	}

	public void putValue(SnmpVar var) {
		variable = var;
	}

	public byte[] encode() {
		if ((oid == null) || (variable == null)) {
			return null;
		}
		byte[]	oidb;
		byte[]	varb;
		byte[]	hdrb;

		if ((oidb = oid.encode()) == null ||
				(varb = variable.encode()) == null) {
			return null;
		}

		hdrb = ASNTypes.putTagLength((byte)(ASNTypes.ASN_SEQUENCE |
				ASNTypes.ASN_CONSTRUCTOR), oidb.length + varb.length);
		if (hdrb == null) {
			return null;
		}

		byte data[] = new byte[oidb.length + varb.length + hdrb.length];

		System.arraycopy(hdrb, 0, data, 0, hdrb.length);
		System.arraycopy(oidb, 0, data, hdrb.length, oidb.length);
		System.arraycopy(varb, 0, data, oidb.length + hdrb.length, varb.length);

		return data;

	}

	public void decode(ByteArrayInputStream pdu) throws SnmpException {
		SnmpVar var;
		int header[] = ASNTypes.getTagLength(pdu);

		if (header[0] != (ASNTypes.ASN_SEQUENCE | ASNTypes.ASN_CONSTRUCTOR)) {
			throw new SnmpException(SnmpErrors.DECODE_ERROR, header[0]);
		}

		var = ASNTypes.decodeVar(pdu);
		if (var.type != SnmpConstants.OBJID) {
			throw new SnmpException(SnmpErrors.DECODE_ERROR, var.type);
		}
		else {
			oid = (SnmpOID)var;
		}

		variable = ASNTypes.decodeVar(pdu);

	}

}
