import jsnmp.*;
import java.util.Vector;

public class snmp{
    
    public static void main(String[] args) {
	SnmpSession session = null;
	boolean isScan = false;
	boolean isSingle = true;
	boolean isWalk = false;
	int port = 161;
	Vector oids = new Vector();
	String[] oid = null;
	Vector[] test = new Vector[3];
	String host = null;
	int scans = 0;
	String community = null;
	MIBparser mp = new MIBparser();
	mp.parseDir("/home/jeremiah/project/mibDir");
	session = new SnmpSession();
	if (args.length > 0){
	    for (int i = 0; i < args.length;i++){
		
		if( args[i].equals("-p")){
		    try {
			port = Integer.parseInt(args[i+1]);
			i++;
		    } catch (NumberFormatException nfe){
			System.out.println("hmm");
		    }
		    session.setPort(port);
		    System.out.println("set port" + port);
		}
		else if(args[i].equals("-h")){
		    host = args[i+1];
		    i++;
		}
		else if (args[i].equals("-c")){
		  session.setCommunity(args[i+1]);
		  i++;
		 }
		else if (args[i].equals("-S")){
		    isScan = true;
		    try {
			scans = Integer.parseInt(args[i+1]);
			i++;
		    } catch (NumberFormatException nfe){
			System.out.println("hmm");
		    }
		}
		else if (args[i].equals("-W")){
		    isWalk = true;
		}
		else{
		    System.out.println(args[i]);
		    oids.addElement("1.3.6.1.2.1."+args[i]);
		    
		}
	    }
	    
	    
	    if ((!isScan) && (!isWalk)){
		System.out.println(oids.size());
		if (oids.size() > 1){
		    //isSingle = false;
		    oid = new String[oids.size()];
		    for (int j = 0; j < oids.size(); j++){
			oid[j] = (String)oids.elementAt(j);
		    }
		}
		else {
		    oid = new String[1];
		    oid[0] = (String)oids.elementAt(0);
		    System.out.println(oid[0]);
		}
		Object[] vars = session.get(host,oid,isSingle);
		if (vars.length  != 0){
		    System.out.println("Number of results:"+vars.length);
		    for (int i = 0; i < vars.length;i++){
			try {
			    //System.out.println("error type:" + ((SnmpErrors)vars[i]).getType());
			    //System.out.println("error code:" + ((SnmpErrors)vars[i]).getCode());
			} catch (NullPointerException npe){
			    //System.out.println("NPE:"+npe);
			    //System.out.println(((SnmpVarBind)vars[i]).getName());
			}
			try {
			    System.out.println(((SnmpVarBind)vars[i]));
			} catch (ClassCastException cce){
			    System.out.println(SnmpPDU.error_number[((SnmpErrors)vars[i]).getType()]);
			}
		    }
		}
	    }
	    else if (isWalk){
		oid = new String[1];
		System.out.println("Walking...");
		Vector childrenOIDs = new Vector();
		String temp = null;
		Vector tree = mp.getTree();
		ObjectNode iso = (ObjectNode)tree.elementAt(0);
		childrenOIDs = iso.getChildren(childrenOIDs,null);
		System.out.println(childrenOIDs.size());
		for (int i = 0 ; i < childrenOIDs.size();i++){
		    oid[0] = (String)childrenOIDs.elementAt(i);
		    Object[] vars = session.get(host,oid,isSingle);
		    if (vars.length  != 0){
			try {
			    //System.out.println(((SnmpVarBind)vars[0]));
			    System.out.println(mp.translateOID(((SnmpVarBind)vars[0]).toString()));
			} catch (ClassCastException cce){
			    //System.out.println(SnmpPDU.error_number[((SnmpErrors)vars[0]).getType()]);
			}    
		    }
		}
	    }
	    else {
		oid = new String[1];
		System.out.println("Under construction");
		int count = 0;
		for (int i = 1; count < scans; i++){
		    for (int j = 1 ; j < 25 & count < scans; j++){
			oid[0] = "1.3.6.1.2.1."+ new Integer(i).toString()+"."+new Integer(j).toString()+".0";
			count++;
			Object[] vars = session.get(host,oid,isSingle);
			if (vars.length  != 0){
			    try {
				//System.out.println(((SnmpVarBind)vars[0]));
				System.out.println(mp.translateOID(((SnmpVarBind)vars[0]).toString()));
			    } catch (ClassCastException cce){
				//System.out.println(SnmpPDU.error_number[((SnmpErrors)vars[0]).getType()]);
			    }
			    
			}
		    }
		}
	    }
	}
    }
}
 
