package ss98.gui;

import ss98.snmp.ss98Host;
import ss98.snmp.OID;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import java.awt.*;
import java.awt.event.*;

import java.util.Vector;
/** Version $Id: HostDialog.java,v 1.2 1999/04/30 06:02:51 jeremiah Exp jeremiah $ 
    this is our dialog to configure a host. Create a new Host Dialog, 
    then run show options on that dialog. This returns an ss98Host class,
    and accepts one if we are going to edit.

    $Log: HostDialog.java,v $
    Revision 1.2  1999/04/30 06:02:51  jeremiah
    need to change so that dialog reflects fact that each snmp has it's own bound.

**/
public class HostDialog extends JComponent implements ActionListener,MouseListener{

    JLabel oidsL = new JLabel("OID");
    JLabel oidNameL = new JLabel("OID Name");
    JLabel hostNameL = new JLabel("Host Name");
    JLabel upperL = new JLabel("Upper");
    JLabel lowerL = new JLabel("Lower");
    JLabel communityL = new JLabel("Community");
    JLabel boundsL = new JLabel("Bounds");
    JLabel limitsL = new JLabel("Limits");
    

    JButton okButton;
    JButton cancelButton;
    JButton addOIDButton;
    JButton delOIDButton;
    JButton editOIDButton;
    JButton setBoundsB;
    JButton setLimitsB;

    JTextField hostnameTF;
    JTextField communityTF;
    JTextField oidTF;
    JTextField oidNameTF;
    JTextField upperBoundTF;
    JTextField lowerBoundTF;
    JTextField upperLimitTF;
    JTextField lowerLimitTF;

    JList oidLI;
    JList oidNameLI;
    JScrollPane oidSP;
    JScrollPane oidNameSP;

    private ss98Host host = null;
    String community;
    String hostname;
    Vector oids = new Vector();
    Vector oidNames = new Vector();
    int upperBound;
    int lowerBound;
    int upperLimit;
    int lowerLimit;

    int Bound;
    int Limit;

    int returnValue = 0;
    private JDialog dialog = null;
   
    public HostDialog(){
	super();
	super.setBounds(0,0,510,485);
	setSize(510,485);
	this.initialize();
    }
    public ss98Host showOptions(Component parent,ss98Host host){ 
	this.host = host;
	hostInit();
	Frame frame = parent instanceof Frame ? (Frame) parent
	    : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
	dialog = new JDialog(frame, "Host Options", true);
	dialog.setBounds(0,0,510,485);
	dialog.setResizable(false);
	Container contentPane = dialog.getContentPane();
	contentPane.setLayout(new BorderLayout());
	contentPane.add(this, BorderLayout.CENTER);
	dialog.setLocationRelativeTo(parent);
	dialog.show();
	if (returnValue ==1){
	    hostComplete();
	    return host;
	}
	else return null;
    }
    /** set all the values in dialog to those in host */
    private void hostInit(){
	this.hostname = host.getHostname();
	this.community = host.getCommunity();
	this.oids = host.getOIDs();
	this.upperBound = host.getUpperBound();
	this.lowerBound = host.getLowerBound();
// 	this.upperLimit = host.getUpperLimit();
// 	this.lowerLimit = host.getLowerLimit();

	this.oidNames = host.getTranslations();

	hostnameTF.setText(hostname);
	communityTF.setText(community);
	upperBoundTF.setText(Integer.toString(upperBound));
	lowerBoundTF.setText(Integer.toString(lowerBound));
// 	upperLimitTF.setText(Integer.toString(upperLimit));
// 	lowerLimitTF.setText(Integer.toString(lowerLimit));
	System.out.println("oids size = "+oids.size());
	System.out.println("oidName size = "+oidNames.size());
	refreshLists();
	refreshBounds();
    }

    private boolean hostComplete(){
	host.setHostname(hostnameTF.getText());
	host.setCommunity(communityTF.getText());
	host.setUpperBound(upperBound);
	host.setLowerBound(lowerBound);
// 	host.setUpperLimit(upperLimit);
// 	host.setLowerLimit(lowerLimit);


	return true;
    }
    /** this is the section, where all of the widgets are defined **/
    private void initialize(){
	
	//labels
	hostNameL.setBounds(10,20,100,25);
	communityL.setBounds(10,50,100,25);
	oidsL.setBounds(140,75,100,25);
	oidNameL.setBounds(340,75,100,25);
	upperL.setBounds(140,250,100,25);
	lowerL.setBounds(340,250,100,25);
// 	limitsL.setBounds(10,360,480,25);
// 	limitsL.setBorder(new EtchedBorder());
	boundsL.setBounds(10,300,480,25);
	boundsL.setBorder(new EtchedBorder());
	add(hostNameL);
	add(communityL);
	add(oidsL);
	add(oidNameL);
	add(upperL);
	add(lowerL);
	add(boundsL);
	//add(limitsL);

	okButton = new JButton("Okay");
	okButton.setBorder(new EtchedBorder());
	okButton.setBounds(50,400,200,25);
	okButton.setActionCommand("ok");
	okButton.addActionListener(this);
	add(okButton);

	cancelButton = new JButton("Cancel");
	cancelButton.setBorder(new EtchedBorder());
	cancelButton.setBounds(275,400,200,25);
	cancelButton.setActionCommand("cancel");
	cancelButton.addActionListener(this);
	add(cancelButton);

	addOIDButton = new JButton("Add OID");
	addOIDButton.setBorder(new EtchedBorder());
	addOIDButton.setBounds(10,100,100,25);
	addOIDButton.setActionCommand("addOID");
	addOIDButton.addActionListener(this);
	add(addOIDButton);

	editOIDButton = new JButton("Edit OID");
	editOIDButton.setBorder(new EtchedBorder());
	editOIDButton.setBounds(10,140,100,25);
	editOIDButton.setActionCommand("editOID");
	editOIDButton.addActionListener(this);
	add(editOIDButton);


	delOIDButton = new JButton("Remove OID");
	delOIDButton.setBorder(new EtchedBorder());
	delOIDButton.setBounds(10,210,100,25);
	delOIDButton.setActionCommand("delOID");
	delOIDButton.addActionListener(this);
	add(delOIDButton);

	setBoundsB = new JButton("Set Bounds");
	setBoundsB.setBorder(new EtchedBorder());
	setBoundsB.setBounds(10,275,100,25);	
	setBoundsB.setActionCommand("setBounds");
	setBoundsB.addActionListener(this);
	add(setBoundsB);

// 	setLimitsB = new JButton("Set Limits");
// 	setLimitsB.setBorder(new EtchedBorder());
// 	setLimitsB.setBounds(10,335,100,25);
// 	setLimitsB.setActionCommand("setLimits");
// 	setLimitsB.addActionListener(this);
// 	add(setLimitsB);


	hostnameTF = new JTextField();
	hostnameTF.setBorder(new EtchedBorder());
	hostnameTF.setBounds(140,20,150,25);
	add(hostnameTF);

	communityTF = new JTextField();
	communityTF.setBorder(new EtchedBorder());
	communityTF.setBounds(140,50,150,25);
	add(communityTF);

	oidTF = new JTextField();
	oidTF.setBorder(new EtchedBorder());
	oidTF.setBounds(140,100,150,25);
	add(oidTF);

	oidNameTF = new JTextField();
	oidNameTF.setBorder(new EtchedBorder());
	oidNameTF.setBounds(340,100,150,25);
	add(oidNameTF);

	upperBoundTF = new JTextField();
	upperBoundTF.setBorder(new EtchedBorder());
	upperBoundTF.setBounds(140,275,150,25);
	add(upperBoundTF);

	lowerBoundTF = new JTextField();
	lowerBoundTF.setBorder(new EtchedBorder());
	lowerBoundTF.setBounds(340,275,150,25);
	add(lowerBoundTF);

// 	upperLimitTF = new JTextField();
// 	upperLimitTF.setBorder(new EtchedBorder());
// 	upperLimitTF.setBounds(140,335,150,25);
// 	add(upperLimitTF);

// 	lowerLimitTF = new JTextField();
// 	lowerLimitTF.setBorder(new EtchedBorder());
// 	lowerLimitTF.setBounds(340,335,150,25);
// 	add(lowerLimitTF);

	oidSP = new JScrollPane();
	oidSP.setBounds(140,135,150,100);
	add(oidSP);
	
	oidNameSP = new JScrollPane();
	oidNameSP.setBounds(340,135,150,100);
	add(oidNameSP);
	
	refreshLists();
	validate();
    }
    public void refreshBounds(){
	//limitsL.setText("Limit: OID = "+((String)oids.elementAt(Limit))+" OID Name = "+((String)oidNames.elementAt(Limit))+" U="+upperLimit+" L="+lowerLimit);
	boundsL.setText("Bound: OID = "+((OID)oids.elementAt(Bound)).oid+" OID Name = "+((OID)oids.elementAt(Bound)).name+" U="+upperBound+" L="+lowerBound);
    }
    public void refreshLists(){
	Vector tempOids = new Vector();
	for (int i = 0 ; i < oids.size(); i++)
	    tempOids.addElement(((OID)oids.elementAt(i)).oid);
	oidLI = new JList(tempOids);
	oidLI.addMouseListener(this);
	oidSP.getViewport().setView(oidLI);
	Vector tempOidNames = new Vector();
	for (int i = 0 ; i < oids.size(); i++)
	    tempOidNames.addElement(((OID)oids.elementAt(i)).name);
	oidNameLI = new JList(tempOidNames);
	oidNameLI.addMouseListener(this);
	oidNameSP.getViewport().setView(oidNameLI);
	validate();
	repaint();
    }
    public void actionPerformed(ActionEvent ae){
	String command = ae.getActionCommand();
	System.out.println(command);
	if (command.equals("cancel")){
	    returnValue =  0;
	    dialog.dispose();
	}
	else if (command.equals("ok")){
	    returnValue =  1;
	    dialog.dispose();
	}
	else if (command.equals("delOID")){
	    int index = oidLI.getSelectedIndex();
	    if (index >= 0 ){
		oids.removeElementAt(index);
		oidNames.removeElementAt(index);
		refreshLists();
		oidTF.setText("");
		oidNameTF.setText("");
	    }
	}
	else if (command.equals("addOID")){
	    String oidTxt = oidTF.getText();
	    String oidNameTxt = oidNameTF.getText();
	    if ((!(oidTxt.equals(""))) && (!(oidNameTxt.equals("")))){
	    oids.addElement(new OID(oidNameTxt,oidTxt,100,0));
	    oidNames.addElement(oidNameTxt);
	    refreshLists();
	    oidTF.setText("");
	    oidNameTF.setText("");
	    }
	}
	else if (command.equals("editOID")){
	    int index = oidLI.getSelectedIndex();
	    if (index >= 0 ){
		String oidTxt = oidTF.getText();
		String oidNameTxt = oidNameTF.getText();
		oids.removeElementAt(index);
		oidNames.removeElementAt(index);
		try {
		    upperBound = Integer.parseInt(upperBoundTF.getText());
		    lowerBound = Integer.parseInt(lowerBoundTF.getText());
		}  catch (NumberFormatException nfe){
		}
		oids.insertElementAt(new OID(oidNameTxt,oidTxt,upperBound,lowerBound),index);
		oidNames.insertElementAt(oidNameTF.getText(),index);
		refreshLists();
		refreshBounds();
		oidTF.setText("");
		oidNameTF.setText("");
	    }
	}
	else if (command.equals("setBounds")){
	    int index = oidLI.getSelectedIndex();
	    if (index >= 0 ){
		try{
		    String oidTxt = oidTF.getText();
		    String oidNameTxt = oidNameTF.getText();
		    upperBound = Integer.parseInt(upperBoundTF.getText());
		    lowerBound = Integer.parseInt(lowerBoundTF.getText());
		    oids.removeElementAt(index);
		    oids.insertElementAt(new OID(oidNameTxt,oidTxt,upperBound,lowerBound),index);
		} catch (NumberFormatException nfe){
		}
		refreshBounds();
	    }
	}
	else if (command.equals("setLimits")){
	    int index = oidLI.getSelectedIndex();
	    if (index >= 0 ){
		try{
		    upperLimit = Integer.parseInt(upperLimitTF.getText());
		    lowerLimit = Integer.parseInt(lowerLimitTF.getText());
		    Limit = index;
		} catch (NumberFormatException nfe){
		}
		refreshBounds();
	    }
	}
    }
    public void itemStateChanged(ItemEvent ie){
	if(ie.getStateChange() == ItemEvent.SELECTED){
	    System.out.println(ie);
	}
    }
    
    public void mouseClicked(java.awt.event.MouseEvent mc){
	//System.out.println("mc");
    }
    public void mousePressed(java.awt.event.MouseEvent mp){
	//System.out.println(mp);
	
    }
    public void mouseReleased(java.awt.event.MouseEvent mr){
	//System.out.println(mr);
	int index = ((JList)mr.getSource()).getSelectedIndex();
	int indexL = oidLI.getSelectedIndex();
	oidLI.setSelectedIndex(index);
	oidNameLI.setSelectedIndex(index);
	if (index == indexL){
	    oidNameSP.getViewport().setViewPosition(oidSP.getViewport().getViewPosition());
	}
	else {
	    oidSP.getViewport().setViewPosition(oidNameSP.getViewport().getViewPosition());
	}
	
	oidTF.setText(((OID)(oids.elementAt(index))).oid);
	oidNameTF.setText(((OID)(oids.elementAt(index))).name);
	lowerBoundTF.setText(Integer.toString(((OID)(oids.elementAt(index))).lowerBound));
	upperBoundTF.setText(Integer.toString(((OID)(oids.elementAt(index))).upperBound));
     
    }
    public void mouseEntered(java.awt.event.MouseEvent me){};
    public void mouseExited(java.awt.event.MouseEvent mx){};
}
