package ss98.gui;

import ss98.snmp.ss98Host;
import ss98.snmp.OID;
import javax.swing.event.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.image.*;
import java.util.*;
import java.beans.*;

/**
   <pre>
   $Id: JCanvas.java,v 1.5 1999/05/06 07:20:02 jeremiah Exp $
   $Log: JCanvas.java,v $
   Revision 1.5  1999/05/06 07:20:02  jeremiah
   Now updateing and displaying oids.
   Added update(int index) and mouse stuff.

   Revision 1.4  1999/05/05 19:28:25  jeremiah
   Documentation test

   </pre>
**/
public class JCanvas extends JComponent implements MouseListener {
    private int width,height,minWidth,minHeight = 0;
    private Vector views = new Vector();
    private Image nodeImage = null;
    //private Image filtered = null;
    private int imageWidth,imageHeight;
    private Vector Images = new Vector();
    private Vector hosts = new Vector();
    private Vector oidImages = new Vector();
    private Color background;
    private int x = 0,y = 0;
    private int index = -1;
    private int[] pixels;
    private float[] boundValues = new float[255];
    private int red,green,blue,alpha;
    private int[] buffer;
    private int fakeColor; 
    private MemoryImageSource mis = null;
    float test = .05f;
    boolean up = true;
    boolean ready = false;
    public JCanvas(Image nodeImage)
    {      
	addMouseListener(this);
	setPreferredSize(400,400);
	setVisible(true);
	MediaTracker mt = new MediaTracker(this);
	mt.addImage(nodeImage,0);
	try {
	    mt.waitForID(0);
	} catch (InterruptedException ie) {
	    System.out.println(ie);
	}
	this.nodeImage = nodeImage;
	
	
	
    }
    public void initPixels(Image nodeImage){
	
	this.imageWidth = nodeImage.getWidth(this);
	this.imageHeight = nodeImage.getHeight(this);
	pixels = new int[imageWidth*imageHeight];
	PixelGrabber pg = new PixelGrabber(nodeImage,0,0,imageWidth,imageHeight,pixels,0,imageWidth);
	try {
	    if(pg.grabPixels() && ((pg.getStatus() & ImageObserver.ALLBITS) != 0)){
		//System.out.println("Status = "+pg.getStatus());
		buffer = new int[pixels.length];
		fakeColor = pixels[1];
		mis = new MemoryImageSource(imageWidth,imageHeight,pixels,0,imageWidth);
		mis.setFullBufferUpdates(true);
	    }
	} catch (Exception e){
	    System.out.println(e);
	}
		background = this.getBackground();
		//System.out.println("RGB = "+background.getRGB()+" R = "+background.getRed()+" G = "+background.getGreen()+" B = "+background.getBlue());
    }

    public void addHost(ss98Host host){
	if (Images.size() == 0){
	    initPixels(nodeImage);
	}
	hosts.addElement(host);
	float tempPercent = host.getPercent();
	//System.out.println("percent = "+tempPercent);
	Image filterImage = filter(tempPercent);
	Images.addElement(filterImage);
	boundValues[Images.indexOf(filterImage)] = tempPercent;
	//System.out.println("Number of Images is "+Images.size());
    }
    public void add(JComponent component){
	views.addElement(component);
    }
    
    public void setPreferredSize(int width, int height)
    {
	this.minWidth = width;
	this.minHeight = height;
    }
   
    public Dimension getPreferredSize()
    {
	return new Dimension(minWidth,minHeight);
    }
    public void paint(Graphics buffer){
	int width = 50;
	int height = 50;
	buffer.setColor(Color.black);
	//buffer.drawLine(0,0,400,400);

	for (int current = 0 ; current < Images.size();current++){
	    float value = boundValues[current];
	    buffer.drawImage((Image)Images.elementAt(current),(current*100)+100-(int)((value*100)/2),100-(int)((test*100)/2),width,height,this);
	    ((ss98Host)hosts.elementAt(current)).location.x = (current*100)+100-(int)((value*100)/2);
	    ((ss98Host)hosts.elementAt(current)).location.y = 100-(int)((test*100)/2);
	    ((ss98Host)hosts.elementAt(current)).location.width = width;
	    ((ss98Host)hosts.elementAt(current)).location.height = height;
	    buffer.drawString(((ss98Host)hosts.elementAt(current)).getHostname(), (current*100)+100-(int)((value*100)/2),100-(int)((test*100)/2));
	    
	    // System.out.println("current:"+current+" x:"+((current*100)+100-(int)((value*100)/2))+" y:"+(100-(int)((test*100)/2))+" w:"+((int)(150*value))+" h:"+((int)(150*value)));
	}
	if (index >= 0){
	    ss98Host host = (ss98Host)hosts.elementAt(index);
	    Rectangle location = host.location;
	    buffer.setColor(Color.blue);
	    buffer.drawRect(location.x,location.y,location.width,location.height);
	    for (int current = 0;current < oidImages.size();current++){
		//System.out.println("Current = "+current);
		Image temp = (Image)oidImages.elementAt(current);
		//System.out.println(temp);
		buffer.drawImage(temp,(current*50)+10,200-(int)((test*200)/2),width-15,height-15,this);
		buffer.drawString(((OID)host.getOIDs().elementAt(current)).name,(current*50)+10,200-(int)((test*200)/2));
		buffer.drawString(((OID)host.getOIDs().elementAt(current)).value,(current*50)+10,250-(int)((test*250)/2));
	    } 
	    
	    
	}
    }
    /** This method takes a percent, and returns an image of a node, that has been 
	color shaded on a gradient of green to red.*/
    public Image filter(float percent){
	//System.out.println("Filter percent = "+percent+"%");
	for (int counter = 0 ; counter < pixels.length; counter++){
	    if (pixels[counter] >= -355444){
		if (background != null)
		    buffer[counter] = background.getRGB();
	    }
	    else {
		alpha = (pixels[counter] >> 24 ) & 0xff;
		//blue = pixels[counter] & 0xff; 
		if (percent < .5f){
		    //System.out.print("p");
		    green = (pixels[counter] >> 8 ) & 0xff;
		    red = (int)((green * (percent / .5f))); 
		}
		else if (percent == .5f){
		    green = (pixels[counter] >> 8 ) & 0xff;
		    red = (pixels[counter] >> 16 ) & 0xff;
		}
		else {
		    //System.out.print("r");
		    red = (pixels[counter] >> 16 ) & 0xff;
		    green = (int)((red*(1-((percent - .5f)/.5f))));
		}
		blue = 0;
		buffer[counter] = (alpha << 24)|(red << 16)|(green << 8)|blue;
	    }
	}
	mis.newPixels(buffer,ColorModel.getRGBdefault(),0,imageWidth);
	return this.createImage (mis);
    }
    public int getSelected(){
	return index;
    }
    public void delHost(int index){
	hosts.removeElementAt(index);
	Images.removeElementAt(index);
	this.index = -1;
	repaint();
    }
    public void mouseClicked(java.awt.event.MouseEvent mc){
	x = mc.getX();
	y = mc.getY();
	
	for (int current = 0; current < hosts.size(); current++){
	    if (((ss98Host)hosts.elementAt(current)).location.contains(x,y)){
		if (index != current)
		    update(current);
	    }
	}
	
	System.out.println("mc");
    }
    public void update(int current){
	
	oidImages = new Vector();
	ss98Host host = (ss98Host)hosts.elementAt(current);
	initPixels(nodeImage);
	Images.setElementAt(filter(host.getPercent()),current);
	Image filterImage = null;
	for (int currentOID = 0;currentOID < host.getOIDs().size();currentOID++){
	    float percent = ((OID)host.getOIDs().elementAt(currentOID)).percent;
	    initPixels(nodeImage);
	    filterImage = filter(percent);
	    oidImages.addElement(filterImage);
	    filterImage.flush();
	} 
	
	index = current;
	repaint();
	return;
		
    }
	

    public void mousePressed(java.awt.event.MouseEvent mp){
	//System.out.println(mp);
	
    }
    public void mouseReleased(java.awt.event.MouseEvent mr){
    }
    public void mouseEntered(java.awt.event.MouseEvent me){};
    public void mouseExited(java.awt.event.MouseEvent mx){};
}
