package ss98.rmi;

import ss98.snmp.*;

import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;

import java.util.Vector;

/** <pre>
    Version $Id: ss98Server.java,v 1.3 1999/05/06 01:05:35 jeremiah Exp $
    $Log: ss98Server.java,v $
    Revision 1.3  1999/05/06 01:05:35  jeremiah
    Added removeHost()

    This is the main enterence point for the server side code. 
    Everything that a client can ask the server to do must be in here. 
    </pre>
**/
public class ss98Server extends UnicastRemoteObject implements ss98Interface {
    Vector hosts = new Vector();
    /** This allows the rmi code to load an instance of the server **/    
    public ss98Server() throws RemoteException{

    }
    /** The server must be started by hand on the server hardware. 
	The main() allows us to do that.It takes a string as an argument
	The string is the name to register the server as. The default is 
	ss98Server
    **/
    public static void main(String argv[]) {
	String registryName = "ss98Server";
	if (argv.length > 0)
	    registryName = argv[0];
	System.out.print("Registering as "+registryName+"..." );
	try {
	    ss98Server server = new ss98Server();
	    Naming.rebind(registryName,server);
	} catch (Exception e){
	    System.out.println("UNSUCCESSFUL! because:");
	    System.out.println(e);
	    System.exit(-1);
	}
	System.out.println("Done");
    }

    public String getOID(String oid)throws RemoteException{
	return "Bubba";
    }
    public ss98Host addHost() throws RemoteException{
	return new ss98Host("localhost","private");
    }
    public ss98Host getHost(ss98Host host) throws RemoteException{
	if (hosts.size() > 0){
	    return (ss98Host)hosts.elementAt(hosts.indexOf(host));
	}
	return null;
    }
    public void removeHost(ss98Host host){
	if (hosts.contains(host)){
	    System.out.println("c: "+host.getHostname());
	    int index = hosts.indexOf(host);
	    hosts.removeElementAt(index);
	}
    }
    public void putHost(ss98Host host) throws RemoteException{
	if (hosts.contains(host)){
	    System.out.println("c: "+host.getHostname());
	    int index = hosts.indexOf(host);
	    hosts.removeElementAt(index);
	    hosts.insertElementAt(host,index);
	}
	else {
	    hosts.addElement(host);
	    System.out.println("cn: "+host.getHostname());
	}
    }
}
