package ss98.snmp;
import java.util.Vector;
import java.io.*;

public class MIBparser{
    
    private String directoryName = null;
    private Vector objectNodes = null;
    private ObjectNode iso = null;
    private boolean debug = false;
    private ObjectNode tempNode = null;

    public MIBparser(){
    }
    public void setDebug(){
	if (debug)
	    this.debug = false;
	else this.debug = true;
    }
    public Vector getTree(){
	return objectNodes;
    }
    public String translateOID(String oid){
	String translation = iso.getTranslation(oid);
	if(debug)
	    System.out.println(translation);
	return translation;
    }
    public void parseDir(String directoryName){
	this.directoryName = directoryName;
	objectNodes = new Vector();
	if (debug) 
	    System.out.println("Parsing mibs in "+directoryName);
	
	//make the head of the tree
	//iso is used in the mibs, but never defined
	iso = new ObjectNode("iso",1,0,null,null);
	objectNodes.addElement(iso);

	//get a list of all the mibs in the directory
	File mibDir = new File(directoryName);
	String[] files = mibDir.list();

	//beging parseing
	String token = null;
	String previousToken = null;
	String childName = null;
	String parentName = null;
	int childID = 0;
	StringBuffer buffer = null;
	MIBTokenizer  mib = null;
	try {
	    for (int currentFile = 0; currentFile < files.length;currentFile++){
		//open file readonly
		mib = new MIBTokenizer(new File(directoryName+"/"+files[currentFile]));
		//parse open file
		childName = null;
		while(true){
		    previousToken = token;
		    token = mib.next();
		   
		    if (token == null)
			break;
		    else if (token.equals("DEFINITIONS")){
			System.out.println("\n"+previousToken);
			while (!(token.equals("BEGIN")))
			       token = mib.next();
		    }
		    else if (token.equals("DESCRIPTION")){
			buffer = new StringBuffer();
			buffer.append(mib.getDescription());
			//System.out.println("DESCRIPTION = "+ buffer);
		    }
		    else if (token.equals("SYNTAX")){
			token = mib.next();
			buffer = new StringBuffer();
			while ((!(token.equals("ACCESS"))) && (!(token.equals("MAX-ACCESS"))) && (!(token.equals("}")))){
			    buffer.append(token+" ");
			    previousToken = token;
			    token = mib.next();
			    // System.out .println("\tStoken "+token);
			    if (token == null)
				break;
			    if (token.equals("OBJECT")){
				token = mib.next();
				if (token.equals("IDENTIFIER")){				    
				    childName = previousToken;
				    // System.out.println("Child = "+childName);
				    break;
				}
			    }
				
			}
			//buffer now contains the syntax
			//System.out.println("SYNTAX = "+ buffer);
			if ((token != null) && (!(token.equals("IDENTIFIER")))){
			    if (!(token.equals("}"))){
				buffer = new StringBuffer();
				buffer.append(mib.next());
			    }
			}
			//buffer now conatins access 
			//System.out.println("ACCESS = "+ buffer);
		    }
		    else if (token.equals("IMPORTS")){
			buffer = new StringBuffer();
			token = mib.next();
			while (!(token.endsWith(";"))){
			    buffer.append(token+" ");
			    token = mib.next();
			}
			buffer.append(token);
			//buffer now contains imports
			//System.out.println("IMPORTS = "+buffer);
		    }
		    else if (token.equals("SEQUENCE")){
			buffer = new StringBuffer();
			token = mib.next();
			while (!(token.equals("}"))){
			    buffer.append(token+" ");
			    token = mib.next();
			}
			buffer.append("}");
			//buffer now contains sequence
			//System.out.println("SEQUENCE = "+buffer);
		    }
		    else if (token.equals("INDEX")){
			buffer = new StringBuffer();
			token = mib.next();
			while (!(token.equals("}"))){
			    buffer.append(token+" ");
			    token = mib.next();
			}
			buffer.append("}");
			//buffer contains index
			//System.out.println("INDEX = "+buffer);
		    }
		    else if (token.equals("STATUS")){
			buffer = new StringBuffer();
			buffer.append(mib.next()+" ");
			//buffer conatins status
			//System.out.println("STATUS = "+ buffer);
		    }
		    else if (token.equals("ACCESS")){
			buffer = new StringBuffer();
			buffer.append(mib.next());
			//buffer contains access
			//System.out.println("ACCESS = "+ buffer);
		    }
		    else if (token.equals("OBJECT-TYPE")){
			    childName = previousToken;						
			//objName now contains oid name			
		    }
		     else if (token.equals("OBJECT-IDENTITY")){
			    childName = previousToken;						
			//objName now contains oid name			
		    }
		    else if (token.equals("MODULE-IDENTITY")){
			    childName = previousToken;						
			//objName now contains oid name			
		    }
		    else if (token.equals("MODULE-COMPLIANCE")){
			    childName = previousToken;						
			//objName now contains oid name			
		    }
		    else if (token.equals("OBJECT-GROUP")){
			    childName = previousToken;						
			//objName now contains oid name			
		    }
		    else if (token.equals("NOTIFICATION-TYPE")){
			    childName = previousToken;						
			//objName now contains oid name			
		    }
		    else if (token.equals("OBJECT")){
			token = mib.next();
			if (token.equals("IDENTIFIER"))
			    childName = previousToken;
			//System.out.println("child = "+childName);
		    }
		    else if (token.equals("::=")){
			if (childName == null)
			    childName = previousToken;
			try {
			    token = mib.next();
			    if (token.equals("{")){
				parentName = mib.next();
				token = mib.next();
				childID = Integer.parseInt(token);
				token = mib.next();
				if (token.equals("}")){
				    //System.out.println(childName+" \t " + childID+" \t"+parentName);
				    System.out.print(".");
				    tempNode = new ObjectNode(childName,childID,0,null,parentName);
				    if(!(iso.buildTree(tempNode))){
					objectNodes.addElement(tempNode);
				
				    }
				    childName = null;
				}
				else 				    
				    System.out.println("problem with "+ token);
				//System.out.print(".");
				
			    }
			    //else System.out.println("boing on "+token);
			     
			} catch (NumberFormatException nfe){
			    //System.out.println(token +" doesn't seem to fit");
			    String tempChildName;
			    while (token.endsWith(")")){
				StringBuffer temp = new StringBuffer();
				int Pos = 0;
				for (int pos = 0 ; token.charAt(pos) != '(';pos++){
				    temp.append(token.charAt(pos));
				    Pos = pos;
				}
				tempChildName = temp.toString();
				temp = new StringBuffer();
				for (int pos = Pos+2; token.charAt(pos) != ')';pos++)
				    temp.append(token.charAt(pos));
				tempNode = new ObjectNode(tempChildName,Integer.parseInt(temp.toString()),0,null,parentName);
				//System.out.println("parent = "+parentName +" child = "+tempChildName+ " childID = "+temp);
				System.out.print(".");
				if(!(iso.buildTree(tempNode))){
				    objectNodes.addElement(tempNode);
				    //System.out.print(".");
				}
				token = mib.next();
				parentName = tempChildName;
			    }
			    childID = Integer.parseInt(token);
			    //System.out.println("parent = "+parentName +" child = "+childName+ " childID = "+childID);
			    System.out.print(".");
			    tempNode = new ObjectNode(childName,childID,0,null,parentName);
			    if(!(iso.buildTree(tempNode))){
				objectNodes.addElement(tempNode);
				//System.out.print(".");
			    }
			    
			    childName = null;
			}
			//System.out.println("Still in the loop");
			//childName = null;
		    }
		    //else
		    //System.out.print("");
		    //System.out.println("\t\ttoken = "+token);
		}
			//System.out.println(" "+objectNodes.size()+" ");
		if (objectNodes.size() > 100)
		    shrinkTree();
		//shrinkTree();
	    }
	} catch (NumberFormatException e){
	    System.out.println(e);
	} 
	System.out.println("\nFinal Parseing and Compression");
	//System.out.println("Number of Nodes left = "+objectNodes.size());
	shrinkTree();
	//iso.finalizeLevel(0);
	//System.out.println("New Number of Nodes left = "+objectNodes.size());
    }

    private void shrinkTree(){
	System.out.println("\nCompressing nodes");
	int oldsize = objectNodes.size();
	int newsize = 0;
	while (oldsize != newsize){
	    oldsize = objectNodes.size();
	    collapseTree();
	    newsize = objectNodes.size();
	}
	for (int i = 0; i < objectNodes.size();i++){
	    ObjectNode temp = (ObjectNode)objectNodes.elementAt(i);
	    //System.out.println(temp.getName()+" Should go in "+temp.getParentName());
	}
    }
    private void collapseTree(){
	int oldSize = objectNodes.size();
	int newSize = 0;
	ObjectNode childnode = null;
	ObjectNode parentnode = null;
	for (int j = 1; j < objectNodes.size();j++ ){
	    childnode = (ObjectNode)objectNodes.elementAt(j);
	    for (int i = 0; i < objectNodes.size(); i++){
		parentnode = (ObjectNode)objectNodes.elementAt(i);
		if (parentnode.buildTree(childnode)){
			objectNodes.removeElement(childnode);
			System.out.print(".");
			break;
		}
	    }
	}
	//System.out.println("\nNEW Number of Nodes Left Over = "+objectNodes.size());
	System.out.println();
    }
}

//this is the class which will break up a mib into tokens 
class MIBTokenizer{
    FileInputStream raf = null;
    StringBuffer buffer = null;
    char temp;
    
    public MIBTokenizer(File file){
	try {
	    raf = new FileInputStream(file);
	} catch (Exception e) {
	    System.out.println(e);
	}
    }
    public String next(){
	int result = 0;
	temp = 10;
	buffer = new StringBuffer();
	while ((temp == 10)||(temp == ' ')|| (temp == '\t'))
	    try {
		result = raf.read();
		if (result == -1)
		    return null;
		temp = (char)result;
		//System.out.print(temp+" ");
	    } catch (Exception e){
		System.out.println("find token "+e);
		return null;
	    }
	
	while ((temp != 10)&&(temp != ' ')&&(temp != -1)&&(temp != '\t')){
	    try { 
		buffer = buffer.append(temp);
		result = raf.read();
		if (result == -1)
		    return null;
		temp = (char)result;
		//System.out.print(temp);
	    } catch (Exception e) {
		System.out.println("goto end "+e);
		return null;
	    }
	}
	
	if (buffer.toString().equals("--")){
	    //System.out.print(".");
	    return skipComment();
	}

	//System.out.println("\t token = "+buffer);
	return buffer.toString();
    }
    public String getDescription(){
	while (temp != '"'){
	    try {
		temp = (char)raf.read();
	    } catch (Exception e){
		System.out.println("find token "+e);
		return null;
	    }
	}
	try {
	    buffer = new StringBuffer();
	    temp = (char)raf.read();
	} catch (Exception e ){
	}
	
	while (temp != '"'){
	    try {
		buffer.append(temp);
		temp = (char)raf.read();
		if (temp == 10){
		    buffer.append(' ');
		    while ((temp  == ' ')||(temp == 10))
			temp = (char)raf.read();
		}
		
	    } catch (Exception e){
		System.out.println("find token "+e);
		return null;
	    }
	}
	return buffer.toString();
	
    }
    public String skipComment(){
	while (temp != 10)
	    try {
		temp = (char)raf.read();
		//System.out.print(temp+" ");
	    } catch (Exception e){
		System.out.println("find token "+e);
		return null;
	    }
	return next(); 
    }
}
