package ss98.snmp;

import java.io.*;
import java.awt.Rectangle;
/** This is the that contains each SNMP oid. It is used so that we can easilty keep track of the bounds and description for each OID
    $Id: OID.java,v 1.4 1999/05/06 06:04:54 jeremiah Exp jeremiah $
    $Log: OID.java,v $
    Revision 1.4  1999/05/06 06:04:54  jeremiah
    Added Location

    Revision 1.3  1999/05/05 20:05:39  jeremiah
    Added update(String value)
    	Takes a string int and set the percent value

    Revision 1.2  1999/04/30 07:31:11  jeremiah
    created

    Revision 1.1  1999/04/30 07:26:36  jeremiah
    Initial revision


**/

public class OID implements Serializable{
    public String name = null;
    public String oid = null;
    public int upperBound = 100;
    public int lowerBound = 0;
    public float percent = 0.0f;
    public Rectangle location = null;
    public String value = "";
    public OID(String name, String oid, int upperBound, int lowerBound){
	this.name = name;
	this.oid = oid;
	this. upperBound = upperBound;
	this.lowerBound = lowerBound;
    }
    public void update(String value){
	int temp;
	try {
	    value = value.substring(oid.length()+2);
	    this.value = value;
	    if (this.value == null)
		this.value = "";
	    System.out.println("temp = "+value);
	    temp = Integer.parseInt(value);
	    
	
	int upper = upperBound - lowerBound;
	temp = temp - lowerBound;
	percent = (float)temp / (float)upper;
	if (percent > 1.0f)
	    percent = 1.0f;
	if (percent <= 0.0f)
	    percent = .1f;
	System.out.println("oid :"+oid+", "+value+", "+percent+", "+upper);
	} catch (NumberFormatException nfe){
	    percent = .05f;
	}
	
    }
}
