package ss98.snmp;
import java.util.Vector;


public class ObjectNode{
    private String name = null;
    private int id = 0;
    private ObjectNode[] children = new ObjectNode[1];
    private ObjectNode parent = null;
    private int level = 0;
    private String parentName = null;
    public ObjectNode(){
	//children.addElement(this);
	
    }
    public ObjectNode(String name, int id,int level, ObjectNode parent, String parentName){
	this.parent = parent;
	this.id = id;
	this.name = name;
	this.level = level;
	this.parentName = parentName;
	//children.addElement(this);
    }
    public void setName(String name){
	this.name = name;
    }
    public void setID(int id){
	this.id = id;
    }
    public void finalizeLevel(int level){
	System.out.println("Changeing level from "+this.level+" to "+level);
	if (!isLeaf())
	    for (int currentChild = 0;currentChild < children.length;currentChild++){
		if (children[currentChild] != null)
		    children[currentChild].finalizeLevel(this.level+1);
	    }
    }
    public void setLevel(int level){

	this.level = level;
	
    }
    public void setParent(ObjectNode parent){
	this.parent = parent;
    }
    //given an OID set we recursivly have to search the entier tree structure
    //until we find ObjectNode with the parent's name;
    public boolean buildTree(String childName, String parentName, int childID ){
	//check to see if this is the new node's parent, if so add it
	if (this.name.equals(parentName)){
	    addChild(new ObjectNode(childName,childID,this.level+1,this,this.name));
	    //System.out.println(name+" added node: "+ "name: "+childName +" id: "+childID+" at level: "+(this.level+1));
	    return true;
	}
	//if this ain't for us send it to all of our children, if they exist
	else {
	    for (int currentChild = 0;currentChild < children.length;currentChild++){
		if (children[currentChild] != null)
		    if (children[currentChild].buildTree(childName,parentName,childID))
			return true;
	    }
	}
	return false;
    }
    public boolean buildTree(ObjectNode childNode){
	if (this.name.equals(childNode.getParentName())){
	    childNode.setLevel(this.level+1);
	    childNode.setParent(this);
	    addChild(childNode);
	    return true;
	}
	else {
	    for (int currentChild = 0;currentChild < children.length;currentChild++){
		if (children[currentChild] != null)
		    if (children[currentChild].buildTree(childNode))
			return true;
	    }
	}
	return false;
    }
    public void addChild(ObjectNode child){
	if (child.getID() >= children.length){
	    ObjectNode[] temp = new ObjectNode[child.getID()+1];
	    for (int i = 0 ; i < children.length; i++){
		temp[i] = children[i];
	    }
	    this.children = temp;
	}
	this.children[child.getID()] = child;
    }
    public boolean isLeaf(){
     	if (children.length == 1)
     	    return true;
     	return false;
    }
    public String getName(){
	return this.name;
    }
    public String getParentName(){
	return this.parentName;
    }
    public int getID(){
	return this.id;
    }
    public ObjectNode getChild(int id){	
	return children[id];
    }
    public Vector getChildren(Vector childrenOIDs, String oid){
	StringBuffer tempOID = null;
	if (oid != null)
	    tempOID = new StringBuffer(oid);
	else tempOID = new StringBuffer();
	tempOID.append("."+Integer.toString(this.id));
	if (isLeaf()){
	    tempOID.append(".0");
	    childrenOIDs.addElement(tempOID.toString());
	}
	else {
	    for (int currentChild = 0;currentChild < children.length;currentChild++){
		if (children[currentChild] != null)
		    childrenOIDs = children[currentChild].getChildren(childrenOIDs,tempOID.toString());
	    }
	}
	return childrenOIDs;
    }
    public ObjectNode getChild(String name){
	for(int i = 0; i < children.length;i++){
	    if (children[i].getName().equals(name))
		return (ObjectNode)children[i];
	}
	return null;
    }
    // this is the crux of the matter
    //we have to be able to parse sn oid like:
    // 1.3.6.1.2.1.6.11.0: 1678057
    public String getTranslation(String oid){
	StringBuffer buffer = new StringBuffer();
	int position = 0;
	int child = 0;
	for (int currentLevel = 0; position < oid.length();position++){
	    if (oid.charAt(position) == '.'){
		currentLevel++;
	       
	    }
	    if (currentLevel > level)
		break;
	}
	
	position++;
	
	while ((oid.charAt(position) != '.')&&(oid.charAt(position) != ':')){
	    
	    buffer.append(oid.charAt(position));
	    position++;
	}
	try {
	    child = Integer.parseInt(buffer.toString());
	    
	} catch (NumberFormatException nfe){
	    System.out.println(buffer + " is not a vaild number @ position:"+position+" currentLevel:"+level);
	}
	if (child == 0){
	    StringBuffer value = new StringBuffer();
	    position++;
	    for (int i = position;i < oid.length();i++)
		value.append(oid.charAt(i));
	    return name + " = " + value;
	}
	if (!(child >= children.length)){
	    if (children[child] != null)
		return new String(name+"."+children[child].getTranslation(oid));
		
	    else return new String("Unknown OID");
	}
	else return new String("Unknown OID");
    }
}
