package ss98.snmp;
import java.io.*;
import java.util.Vector;
import jsnmp.*;
import java.awt.Rectangle;

/** <pre>
    Version $Id: ss98Host.java,v 1.5 1999/05/06 07:19:14 jeremiah Exp $ 
    This is where all the information on a particular host is gathered 
    as well as saved. Hosts are stored and polled by snmpControl. 
    $Log: ss98Host.java,v $
    Revision 1.5  1999/05/06 07:19:14  jeremiah
    Finalized for moment

    Revision 1.4  1999/05/05 20:18:13  jeremiah
    added getPercent() and tied in poll()

    Revision 1.3  1999/05/05 20:08:59  jeremiah
    Changed update to reflect change in OID.update

    Revision 1.2  1999/04/30 05:59:27  jeremiah
    Need to change code to reeflect single bound for each oid

    </pre>
**/
public class ss98Host implements Serializable {
    private String community;
    private String hostname;
    private int port = 161;
    private Vector translations;
    private Vector oids;
    private String[] oid = new String[1];
    private transient SnmpSession session = null;
    private int upperBound;
    private int lowerBound;
    private int upperLimit;
    private int lowerLimit;
    private float percent = 0.0f;
    public Rectangle location = new Rectangle();

    /** generic creation **/
    public ss98Host(){
	
    }
    /** make a new instance passing the hastname, and the community **/
    public ss98Host(String hostname, String community){
	this.hostname = hostname;
	this.community = community;
	translations = new Vector();
	oids = new Vector();
// 	addOID("1.3.6.1.2.1.1.1.0","system.name",100,0);
// 	addOID("1.3.6.1.2.1.1.1.0","system.description",100,1);
// 	addOID("1.3.6.1.2.1.1.2.0","system.location",100,2);
// 	addOID("1.3.6.1.2.1.1.3.0","system.uptime",100,3);
// 	addOID("1.3.6.1.2.1.1.4.0","system.owner",100,4);
// 	addOID("1.3.6.1.2.1.1.5.0","system.builddate",100,5);
// 	addOID("1.3.6.1.2.1.1.6.0","system.users",100,6);
// 	addOID("1.3.6.1.2.1.1.7.0","system.services",100,7);
// 	addOID("1.3.6.1.2.1.1.8.0","system.bugs",100,8);
	addOID("1.3.6.1.2.1.1.5.0","System",100,0);
	addOID("1.3.6.1.2.1.2.2.1.4.1","?",6000,3924);
	addOID("1.3.6.1.2.1.2.2.1.4.2","?",3000,1480);
	addOID("1.3.6.1.2.1.2.2.1.4.3","?",3000,1476);
	addOID("1.3.6.1.2.1.2.2.1.4.4","?",3000,1480);
	addOID("1.3.6.1.2.1.2.2.1.4.5","?",3000,1500);
	addOID("1.3.6.1.2.1.2.2.1.4.6","?",3000,1500);
	addOID("1.3.6.1.2.1.11.1.0","?",10000,1500);
	addOID("1.3.6.1.2.1.11.2.0","?",10000,1500);



    }
    public Vector getOIDs(){
	return oids;
    }
    public Vector getTranslations(){
	return translations;
    }
    public void setOIDs(Vector oids){
	this.oids = oids;
    }
    public void setTranslations(Vector translations){
	this.translations = translations;
    }
    public String getHostname(){
	return hostname;
    }
    public String getCommunity(){
	return community;
    }
    public int getUpperBound(){
	return upperBound;
    }
    public int getLowerBound(){
	return lowerBound;
    }
    public int getUpperLimit(){
	return upperLimit;
    }
    public int getLowerLimit(){
	return lowerLimit;
    }
    public float getPercent(){
	poll();
	percent = 0.0f;
	for (int current = 0; current < oids.size(); current++){
	    OID temp = (OID)oids.elementAt(current);
	    if (temp.percent > percent)
		percent = temp.percent;
	}
	return percent;
    }
    public void setUpperBound(int upperBound){
	this.upperBound = upperBound;
    }
    public void setLowerBound(int lowerBound){
	this.lowerBound = lowerBound;
    }
    public void setUpperLimit(int upperLimit){
	this.upperLimit = upperLimit;
    }
    public void setLowerLimit(int lowerLimit){
	this.lowerLimit = lowerLimit;
    }
    /** set the port of the remote snmp server **/
    public void setPort(int port){
	if (session != null)
	    session.setPort(port);
	this.port = port;
    }
    /** set the community that will be queried **/
    public void setCommunity(String community){
	if (session != null)
	    session.setCommunity(community);
	this.community = community;
    }
    public void setHostname(String hostname){
	this.hostname = hostname;
    }
    /** returns a vector of all values we care about. oids only at the moment **/
    public void poll(){
	if (session == null){
	    session = new SnmpSession();
	    session.setCommunity(community);
	    session.setPort(port);
	}
	Object[] vars = null;
	for (int current = 0; current < oids.size();current++){
	    System.out.println("poll: "+oids.size());
	    String test1 = ((OID)oids.elementAt(current)).oid;
	    System.out.println("poll: "+test1);
	    this.oid[0] = test1;
	    vars = session.get(hostname,oid,true);
	    try {
		//System.out.println(((SnmpVarBind)vars[0]).toString());
		((OID)oids.elementAt(current)).update(((SnmpVarBind)vars[0]).toString());
	    } catch (ClassCastException cce){
		System.out.println(SnmpPDU.error_number[((SnmpErrors)vars[0]).getType()]);
	    }   
	}
    }
    /** add an oid to our poll list **/
    public void addOID(String oid, String name,int upperBound, int lowerBound){
	oids.addElement(new OID(name,oid,upperBound,lowerBound));
	System.out.println("oids.size = "+oids.size()+" oid = "+name);
	translations.addElement(name);
    }
    
}
