package ss98;

import ss98.rmi.*;
import ss98.gui.*;
import ss98.snmp.ss98Host;

import java.applet.*;
import java.rmi.*;
import java.rmi.server.*;

import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.*;

import java.awt.event.*;
import java.awt.*;
import java.awt.image.*;

import java.util.*;
import java.beans.*;
/** Version $Id: ss98Client.java,v 1.5 1999/05/06 07:20:35 jeremiah Exp $ 
    $Log: ss98Client.java,v $
    Revision 1.5  1999/05/06 07:20:35  jeremiah
    Added edit host and got working

 **/
public class ss98Client extends Applet implements PropertyChangeListener , ActionListener {

    JFrame frame = null;
    JCanvas canvas = null;
    JToolBar toolbar = null;
    private Hashtable keyTable = new Hashtable(5);
    ss98Server_Stub server = null;
    HostDialog hd = new HostDialog();
    Vector hosts = new Vector();
    int[] pixels;
    Image nodeImage = null;

    /** This initializes the applet 
     **/
    public void init(){
	frame = new JFrame("SS98");
	frame.setSize(400,400);

	

	//make actions
	createActions();
	//make toolbar
	createToolBar();
	//make menu;
	
	createMenuBar();
	//get Image
	nodeImage = this.getImage(this.getCodeBase(),"images/node.jpg");
	canvas = new JCanvas(nodeImage);
	canvas.setPreferredSize(400,350);

	frame.setJMenuBar((JMenuBar)getValue("menubar"));
	frame.getContentPane().add((JToolBar)getValue("toolbar"),BorderLayout.NORTH);
	frame.getContentPane().add(canvas,BorderLayout.CENTER);
	
	frame.setVisible(true);
	frame.validate();

	frame.repaint();
	
    }
    
    public void start(){
	String serverName = "ss98Server";
	String MyLocation = null;
	
	MyLocation = this.getDocumentBase().getHost();
	try {
	    server = (ss98Server_Stub)Naming.lookup("rmi://"+MyLocation+"/"+serverName);
	} catch (Exception e) { 
	    System.out.println(e); 
	}
	System.out.println("location = "+MyLocation);
	try {
	    System.out.println(server.getOID("chunky"));
	} catch (Exception e){
	    System.out.println(e);
	}

	//test crap

		
    }
    private void createActions(){    
	putValue("addhost", new anAction("Add a Host",this,"images/addhost.gif","Add a Host",KeyStroke.getKeyStroke('s',8),"addhost",true));
	putValue("delhost", new anAction("Delete a Host",this,"images/delhost.gif","Delete a Host",KeyStroke.getKeyStroke('s',8),"delhost",true));
	putValue("edithost", new anAction("Edit a Host",this,"images/edithost.gif","Edit a Host",KeyStroke.getKeyStroke('s',8),"edithost",true));
	putValue("saveconfig", new anAction("Save current Settings",this,"images/saveconfig.gif","Save current settings",KeyStroke.getKeyStroke('s',8),"saveconfig",true));
	putValue("loadconfig", new anAction("Load saved settings",this,"images/loadconfig.gif","load saved settings",KeyStroke.getKeyStroke('s',8),"loadconfig",true));
	
    }
    private void createToolBar(){
	JButton b = null;
	MyJToolBar toolbar = new MyJToolBar();
	putValue("toolbar",toolbar);
	toolbar.add((Action)getValue("addhost"));
	toolbar.add((Action)getValue("delhost"));
	toolbar.add((Action)getValue("edithost"));
	toolbar.add((Action)getValue("saveconfig"));
	toolbar.add((Action)getValue("loadconfig"));
	

    }
    
    private void createMenuBar(){
	JMenuBar menubar = new JMenuBar();
	putValue("menubar",menubar);     
	MyJMenu fileMenu = new MyJMenu("File");
	//JDBIMenu editMenu = new JDBIMenu("Edit");
	///JDBIMenu erdMenu = new JDBIMenu("ERD");
	//JDBIMenu viewMenu = new JDBIMenu("View");
	//JDBIMenu windowMenu = new JDBIMenu("Window");
	//JDBIMenu helpMenu = new JDBIMenu("Help");
	fileMenu.add((Action)getValue("addhost"));
	fileMenu.add((Action)getValue("delhost"));
	fileMenu.add((Action)getValue("edithost"));
	fileMenu.add((Action)getValue("saveconfig"));
	fileMenu.add((Action)getValue("loadconfig"));
	menubar.add(fileMenu);
    }

    //Process action events here
    public void actionPerformed(java.awt.event.ActionEvent ae){
	ImageIcon im = new ImageIcon();
	System.out.println(ae.getActionCommand());
	if (ae.getActionCommand().equals("addhost")){
	    addHost();
	}
	else if (ae.getActionCommand().equals("delhost")){
	    delHost();
	}
	else if (ae.getActionCommand().equals("edithost")){
	    editHost();
	}
    
    }
    /** this is the add host method. It asks the server for a new ss98Host object, 
       and then displays it to the user for confguration. When finished is then sends the host 
       back to the server for storage and polling. */
    private void addHost(){
	try {
	    ss98Host host = server.addHost();
	    if (hd.showOptions(frame,host) != null){
		System.out.println(host.getHostname());
		server.putHost(host);
		hosts.addElement(host);
		canvas.addHost(host);
	    }
	    
	} catch (RemoteException re){
	    System.out.println(re);
	}
    }
    private void delHost(){
	int index = canvas.getSelected();
	if (index < 0)
	    return;
	ss98Host host = (ss98Host)hosts.elementAt(index);
	try {
	    server.removeHost(host);
	} catch (RemoteException re){
	    System.out.println(re);
	}
	canvas.delHost(index);
	hosts.removeElementAt(index);
    }

    private void editHost(){
	int index = canvas.getSelected();
	if (index < 0)
	    return;
	ss98Host host = (ss98Host)hosts.elementAt(index);
	hd.showOptions(frame,host);
	    canvas.update(index);
	
    }


    //Property change support*******************************************
    protected java.beans.PropertyChangeSupport changeSupport;

    public Object getValue(String key) {
	return keyTable.get(key);
    }
    
    public synchronized void putValue(String key, Object newValue) {
	Object oldValue = null;
	if (keyTable.containsKey(key))
	    oldValue = keyTable.get(key);
	keyTable.put(key,newValue);
	firePropertyChange(key, oldValue, newValue);
    }
    
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	if (changeSupport == null) {
	    return;
	}
	changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
    
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
	if (changeSupport == null) {
	    changeSupport = new java.beans.PropertyChangeSupport(this);
	}
	changeSupport.addPropertyChangeListener(listener);
    }
    
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
	if (changeSupport == null) {
	    return;
	}
	changeSupport.removePropertyChangeListener(listener);
    }

    public void propertyChange(java.beans.PropertyChangeEvent pce){
	System.out.println(pce);
    }
}
