package ss98.system;
import java.io.*;//this is so we can do file manipulation
import java.util.*;         //this is so we can use Vectors




public class ProcParser{
    private Vector Processes = new Vector();
    private Vector Sockets = new Vector();
    private Vector ProcessSockets = new Vector();

    public ProcParser(){
	getSysinfo();
	//getProcesses();         //these two are solely for debuging purposes at the moment
	//getSockets();
	         //LinuxSocket ls = new LinuxSocket();
	         //ls.update();
    }

    public Vector getProcesses(){
	LinuxSocket ls = null;
	Vector lsockets = null;
	//this is a Process object defined by Process.class
	Process process = null;          
	//this is a Vector of Process objects
	Vector procies = new Vector(); 
	//open the /proc directory for reading all the process numbers
	File dir = new File("/proc");          
	//remove all of the old Scokets
	ProcessSockets.removeAllElements();
	//read the /proc directory
	String[] procs = dir.list();         
	//for every entry in the directory get the process information
	for (int i = 0; i < procs.length;i++){          
	    //if the directory entry is not a number then it's not a PID so bail out
	    try {          
		//check to see if entry is a number throws Number format exception if it isn't
		Integer.valueOf(procs[i]);         
		//if it passes the test make a new process useing only it's PID
		process = new Process(procs[i]);         
		//print out each process
		System.out.println(process);         
		lsockets = process.getSockets();
		//get the number of Sockets connected to the process
		for (int j = 0; j < lsockets.size();j++){         
		    ls = (LinuxSocket)(lsockets.elementAt(j));
		    System.out.println(ls);
		    //for each one add it to our vector of processes
		    ProcessSockets.addElement(ls);        
		    
		}
		//add each process to our vector of processes
		procies.addElement(process);         
		
	    }
	    //this is our bail point if it's not a number. Don't do anything.
	    catch (NumberFormatException nfe){
		
	    }
	    //move on to the next directory entry
	}          
	
	System.out.println("Number of Processes = "+procies.size()+" Number or Sockets = "+ProcessSockets.size());
	//return our new  vector of processes
	return procies;          
	
    }
    public Vector getDevices(){
	return new Vector();
    }
    public Vector getSockets(){
	//this is our vector of Inodes from /proc/net/[tcp,unix,raw,udp] we use this so we can close the file quickly
	Vector Inodes = new Vector();          
	//this is our internal vector of Sockets
	Vector Sockets = new Vector();          
	//the file reader for the /proc/net/tcp file
	FileReader tcp = null;         
	//the file reader for the /proc/net/unix file
	FileReader unix = null;         
	//the file reader for the /proc/net/udp file
	FileReader udp = null;         
	//the file reader for the /proc/net/raw file
	FileReader raw = null;         
	//A simple linenumber reader so we can work line by line easily
	LineNumberReader lnr = null;         
	//this is our temp string where the output of LineNumberReader.readLine() goes
	String line = null;         
	//this is so we can keep track of where we are in the list of inodes
	int i = 0;         
	//this watches to make sure that the file we are looking fo is there
	try {          
	    //open file for reading
	    tcp = new FileReader("/proc/net/tcp");          
	    //wrap it in a line number reader
	    lnr = new LineNumberReader(tcp);         
	    // watch to make sure we have something more to read
	    try {         
		//keep looping till we throw an exception
		while (true){         
		    //read a line
		    line = lnr.readLine();         
		    //catch any text we might get from the header "inode" esp.
		    try {         
			//add an inode to the list
			Inodes.addElement(Integer.valueOf(line.substring(90,100).trim()));         
			//do nothing if we get text
		    } catch (NumberFormatException nfe){          

		    }
		}
		//do nothing if we reach the end of the file automatically closes it
	    } catch (IOException ioe){        
		//make sure we have some data to read do nothing if we don't
	    } catch (NullPointerException npe){         
	    }
	    //loop thru each inode so far
	    for (;i<Inodes.size();i++)   
		//make a new socket out of each inode and add it to our list of sockets
		Sockets.addElement(new LinuxSocket(((Integer)Inodes.elementAt(i)).intValue(),1));         
	    //open the udp table for reading
	    udp = new FileReader("/proc/net/udp");        
	    //same as above, could put all this in one big for loop
	    lnr = new LineNumberReader(udp);         
	    try {
		while (true){
		    line = lnr.readLine();
		    try {
			Inodes.addElement(Integer.valueOf(line.substring(90,100).trim()));
		    } catch (NumberFormatException nfe){
		    }
		}
	    } catch (IOException ioe){
	    } catch (NullPointerException npe){
	    }
	    for (;i<Inodes.size();i++)
		Sockets.addElement(new LinuxSocket(((Integer)Inodes.elementAt(i)).intValue(),2));
	    raw = new FileReader("/proc/net/raw");
	    lnr = new LineNumberReader(raw);
	    try {
		while (true){
		    line = lnr.readLine();
		    try {
			Inodes.addElement(Integer.valueOf(line.substring(90,100).trim()));
		    } catch (NumberFormatException nfe){
		    }
		}
	    } catch (IOException ioe){
	    } catch (NullPointerException npe){
	    }
	    for (;i<Inodes.size();i++)
		Sockets.addElement(new LinuxSocket(((Integer)Inodes.elementAt(i)).intValue(),3));
	    unix = new FileReader("/proc/net/unix");
	    lnr = new LineNumberReader(unix);
	    try {
		while (true){
		    line = lnr.readLine();
		    try {
			//the unix protocal file has this in a differnt layout
			Inodes.addElement(Integer.valueOf(line.substring(45,50).trim()));         
		    } catch (NumberFormatException nfe){
		    }
		}
	    } catch (IOException ioe){
	    } catch (NullPointerException npe){
	    }
	    for (;i<Inodes.size();i++)
		Sockets.addElement(new LinuxSocket(((Integer)Inodes.elementAt(i)).intValue(),4));
	    //bail out if the file we are looking for doesn't exist
	} catch (FileNotFoundException fnfe){         
	}
	
	System.out.println("Number of Sockets = "+Sockets.size()+" Inodes size = "+Inodes.size());
	//  return all of our newly created sockets
	return Sockets;         
    }
    public Vector getNetDevices(){
	return new Vector();
    }


    /**this parses the /proc/meminfo file and returns an array of ints.
       Meminfo[]
	0 total mem in bytes
	1 used mem in bytes
	2 free mem in bytes
	3 shared mem in bytes
	4 buffered mem in bytes
	5 cached mem in bytes
	6 total swap space in bytes
	7 used swap space in bytes
	8 free swap space in bytes
	9 total mem in Kb
	10 free mem in Kb
	11 shared mem in Kb
	12 Bufferes in Kb
	13 Cached mem in Kb
	14 Toatl swap in Kb
	15 Free swap in Kb
    **/	
    public int[] getMemInfo(){
	int MemInfo[] = new int[16];
	StreamTokenizer meminfoStream = null;
	try {
	    FileReader meminfo = new FileReader("/proc/meminfo");
	    meminfoStream = new StreamTokenizer(meminfo);
	} catch (FileNotFoundException fnfe){
	    System.out.println(fnfe);
	}
	int count = 0;
	while (meminfoStream.ttype != StreamTokenizer.TT_EOF){
	    try {
		meminfoStream.nextToken();
	    } catch (IOException IOE) {
		System.out.println("breaking!");
		break;
	    }
	    if (meminfoStream.ttype == StreamTokenizer.TT_NUMBER){
		//System.out.println((new Double(meminfoStream.nval)).intValue());
		MemInfo[count] = (new Double(meminfoStream.nval)).intValue();
		count++;
	    }
	}


	return MemInfo;
    }



    /** this parses the /proc/stat file. It skips the interupt section
	This returns an array of ints where theindex equals the following:
	cpu_user,
	cpu_nice,
	cpu_system,
	ticks - (cpu_user + cpu_nice + cpu_system),
	dk_drive[0], 
	dk_drive[1],
	dk_drive[2], 
	dk_drive[3],
	dk_drive_rio[0], 
	dk_drive_rio[1],
	dk_drive_rio[2], 
	dk_drive_rio[3],
	dk_drive_wio[0], 
	dk_drive_wio[1],
	dk_drive_wio[2], 
	dk_drive_wio[3],
	dk_drive_rblk[0], 
	dk_drive_rblk[1],
	dk_drive_rblk[2], 
	dk_drive_rblk[3],
	dk_drive_wblk[0], 
	dk_drive_wblk[1],
	dk_drive_wblk[2], 
	dk_drive_wblk[3],
	pgpgin,
	pgpgout,
	pswpin,
	pswpout,
	context_swtch,
	xtime.tv_sec - jiffies / HZ,
	total_forks
    **/

    public int[] getSysinfo(){
	int SysInfo[] = new int[32];
	StreamTokenizer sysinfoStream = null;
	try {
	    FileReader sysinfo = new FileReader("/proc/stat");
	    sysinfoStream = new StreamTokenizer(sysinfo);
	} catch (FileNotFoundException fnfe){
	    System.out.println(fnfe);
	}
	int count = 0;
	try {
	    while (sysinfoStream.ttype != StreamTokenizer.TT_EOF){
		sysinfoStream.nextToken();
		if (sysinfoStream.ttype == StreamTokenizer.TT_NUMBER){
		    System.out.println((new Double(sysinfoStream.nval)).intValue());
		    SysInfo[count] = (new Double(sysinfoStream.nval)).intValue();
		    count++;
		}
		else if (sysinfoStream.ttype == StreamTokenizer.TT_WORD){
		    if (sysinfoStream.sval.equals("intr")){
			sysinfoStream.nextToken();
			while (sysinfoStream.ttype != StreamTokenizer.TT_WORD ){
			    sysinfoStream.nextToken();
			}
		    }
		}
	    }
	} catch (IOException IOE) {
	    System.out.println(IOE);
	}

	return SysInfo;
    }
    /*
    public OsInfo getOsInfo(){
    }*/
}
