package ss98.system;
import java.io.*;
import java.util.Vector;


/**
   The service class is the class that watches processes 
for specific behavior associated with a user defined service such
as httpd or ftpd etc. It also compares the statistics of a service 
to a set of user defined values and reports on them. At some point in time the ability to add 
more than one stat to a color or size monitor should be added. For example add the percent of
memory use to the percent of cpu use and devide by the nuber of pages in memory. 
**/

public class Service implements Serializable {
    /** The name of the service exp. "telnet" **/
    String name = null;
    /** Executable name of service exp. "in.telnetd". 
	Perhaps there should be multiple possibilities?
    **/
    String pname = null;
    /** The process stat to monitor to determine the size of it's representation. **/
    String SizeStat = null;
    /** The minumum value of the size stat.**/
    int SizeStatMin = 0;
    /** The maximum size possible for the stat. If a stat goes over this, we will ignore it. **/
    int SizeStatMax = 100;
    /** The process stat to monitor to determine the color of it's representation. **/
    String ColorStat = null;
    /** The minumum value of the size stat.**/
    int ColorStatMin = 0;
    /** The maximum value of the size stat.**/
    int ColorStatMax = 100;
    /** The PIDs of processes which are a members of this service. **/
    Vector PIDs = null;
    /** The Parent PID. This is the PID of the Process which forks off other like services. **/
    int PPID = 0;

    public Service() {
	
    }
    /** This updates all stats on a service. 
	If something changed, true is returned, else false if everything stayed the same. 
	It does all of this by searching through a vector of processes. 
    **/
    public boolean update(Vector Procs){
	//boing boing
	return true;
    }
}
